﻿//////////////////////////////////////////////
// ThreadWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class LogManager ;
}

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkTasksWrap
{
	class DLL_ASTRAEUS_EXPORT ThreadWrapper final
	{
		public :

			// Env
			static void updateEnvironment (nkScripts::Environment* env, LogManager* targetLogManager) ;

			// Callbacks
			// Constructeur, destructeur
			static void* constructor (LogManager* logManager, const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			// Threading
			static nkScripts::OutputValue addTask (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue releaseTaskRef (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue run (const nkScripts::DataStack& stack) ;
			// Utils pour l'environnement
			static nkScripts::OutputValue runScript (const nkScripts::DataStack& stack) ;

		private :

			// Constructeur, destructeur
			ThreadWrapper () = delete ;
			~ThreadWrapper () = delete ;
	} ;
}